# 4. 프로세스의 개념

Created: January 24, 2022 1:07 PM
Reviewed: No

# 들어가며

---

## 핵심 질문: CPU가 여러 개 존재한다는 환상을 어떻게 제공하는가

운영체제는 CPU를 가상화

- 시분할(time sharing): 여러 개체가 일정 시간동안 돌아가며 자원을 사용하는 방식
- 공간 분할(space sharing): 개체에게 공간을 분할

 CPU 가상화의 효율적 구현

- 매커니즘: 필요한 기능을 구현하는 방법
    - ex) 문맥 교환(context switch)
- 정책: 어떤 결정을 내리는 데 사용되는 알고리즘
    - ex) 스케줄링 정책(scheduling policy)

# 1. 프로세스의 개념

---

## 프로세스(process)

실행중인 프로그램

## 프로세스의 하드웨어 상태

- 메모리(주소 공간)
    - 명령어, 실행프로그램이 읽고 쓰는 데이터 저장
- 레지스터
    - 프로그램 카운터(program counter, PC) 또는 명령어 포인터(instruction pointer, IP) : 프로그램의 어느 명령어가 실행중인지 알려줌
    - 스택 포인터(stack pointer)와 프레임 포인터(frame pointer): 함수의 변수와 리턴 주소를 저장하는 스택 관리에 사용되는 레지스터
- 영구 저장장치

# 2. 프로세스 API

---

- 생성(Create): 새로운 프로세스 생성
- 제거(Destroy): 프로세스를 강제로 제거
- 대기(Wait): 어떤 프로세스의 실행 중지를 기다림
- 각종 제어(Miscellaneous Control): 프로세스를 일시 정지, 재개 등 여러가지 제어 기능 제공
- 상태(Status): 프로세스의 상태 정보를 얻어냄

# 3. 프로세스 생성 : 좀 더 자세하게

---

## 1. 프로그램 코드와 정적 데이터 를 메모리에 로드

프로그램은 디스크 또는 플래시 기반 SSD에 실행 파일 형식으로 존재함. 운영체제는 디스크의 해당 바이트를 읽어서 메모리에 저장함. 

초기 운영체제: 모든 코드, 데이터 메모리에 로드

현대 운영체제: 프로그램을 실행하면서 필요한 부분만 메모리에 탑재

- 페이징(paging)
- 스와핑(swapping)

![4-1.png](./assets/4-1.png)

## 2. 특정 메모리 공간에 스택(run-time stack) 할당

C프로그램은 지역 변수, 함수 인자, 리턴 주소등을 저장하기 위해 스택을 사용함. 운영체제는 스택을 주어진 인자로 초기화(main() 함수의 인자인 argc, argv))

## 3. 힙(heap)을 위한 메모리 영역 할당

C프로그램에서 힙은 동적으로 할당된 데이터를 저장하기 위해 사용됨. (malloc(), free()) 힙은 연결리스트, 해시 테이블, 트리 등 크기가 가변적인 자료구조를 위해 사용됨. 

## 4. 입출력과 관계된 초기화 작업 수행

- 표준 입력(STDIN)
- 표준 출력(STDOUT)
- 표준 에러(STDERR)

UNIX 시스템에서는 각 장치에 해당하는 3개의 파일 디스크립터를 가짐. 파일 디스크립터를 사용해 프로그램이 터미널로부터 입력을 읽고 화면에 출력을 프린트하는 작업을 쉽게 할 수 있음.

## 5. main()에서부터 프로그램 실행 시작

운영체제는 프로그램 시작 지점인 main() 루틴으로 분기함으로써 운영체제는 CPU를 새로 생성된 프로세스에게 넘기고 프로그램 실행 시작.

# 4. 프로세스 상태

---

- 실행(Running): 실행 상태에서 프로세스는 프로세서에서 실행 중
- 준비(Ready): 준비 상태에서 프로세스는 실행할 준비가 되어있으며 대기 중
- 대기(Blocked):  프로세스가 다른 사건을 기다리는 동안 프로세스의 수행을 중단 ex) 프로세스가 디스크에 대한 입출력 요청시, 프로세스는 입출력 완료시까지 대기 상태, 다른 프로세스가 실행 상태로 될 수 있음

![4-2.png](./assets/4-2.png)

준비 상태에서 실행 상태로 전이: 프로세스 스케줄

실행 상태에서 준비 상태로 전이: 나중에 다시 스케줄 될 수 있는 상태가 됨

실행 상태에서 대기 상태로 전이: 입출력 요청 등의 이유, 요청 완료 등의 이벤트가 발생할 때까지 대기 상태 유지

대기 상태에서 준비 상태로 전이: 대기 상태에서 이벤트 발생 시 

# 5. 자료 구조

---

운영체제에는 다양한 자료 구조 존재

- 프로세스 리스트: 시스템에서 실행 중인 프로그램을 관리, 각 노드는 프로세스 제어블럭
- 프로세스 제어 블럭(process control block, PCB) 또는 프로세스 기술자: 프로세스 관리를 위한 정보를 저장하는 자료 구조
- 레지스터 문맥(register context) 자료구조: 프로세스가 중단되었을 때 해당 프로세스의 레지스터값들을 저장. 이 레지스값 복원하여 프로세스 실행 제개

프로세스의 또 다른 상태

- 초기(Initial): 프로세스가 완전히 생성되기 전까지의 상태
- 최종(final): 프로세스는 종료되었지만 사용하던 자원들이 아직 완전히 반납되지 않은 상태. (유닉스 기반 시스템에서 좀비 상태)
    - 다른 프로세스가 성공적으로 실행을 마쳤는지를 파악하는 데 사용. (유닉스 기반 시스템에서 성공적으로 종료시 0, 아니면 0이 아닌 값 반환)